#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye: register (c8);
float4 fogData : register (c9);
float4 ambientBase : register (c12);
float4 directionalBase : register (c13);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos  : POSITION;
   float4 Diff : COLOR0;
#if OMNI == 1 || SPOT == 1
   float4 Omni : COLOR1;
#endif   
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
   float2 Tex  : TEXCOORD0;
};

#if OMNI == 1

  #if NUMTEX == 1
    VS_OUTPUT vs11_nonDirectionalOmniT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #else  
    VS_OUTPUT vs11_nonDirectionalOmni (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #endif  

#elif SPOT == 1

  #if NUMTEX == 1
    VS_OUTPUT vs11_nonDirectionalSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #else  
    VS_OUTPUT vs11_nonDirectionalSpot (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #endif  

#else

  #if NUMTEX == 1
    VS_OUTPUT vs11_nonDirectionalT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #else  
    VS_OUTPUT vs11_nonDirectional (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex : TEXCOORD0)
  #endif  

#endif
  
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);

#ifdef USEFOG
  // compute fog
  float3 eyeVec = mul (worldMatrix, inPos.xyz) + worldEye.xyz;
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif
  
#if OMNI == 1
  // Compute omnilights
  Out.Omni = (0,0,0,0);
  Out.Omni.a = inColor.a;
  
  float3 worldPos = mul (worldMatrix, inPos);
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  for (int i=0; i<7; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        Out.Omni.rgb += (intens * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,0);
  float3 worldPos = mul (worldMatrix, inPos);
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Omni = spotColor;

#endif

  // Propagate color and texture coordinates:
  Out.Diff = inColor * saturate (ambientBase + directionalBase);
  Out.Tex = inTex;

  return (Out);
}








